/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.EventHooks;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.config.ConfigScript;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.items.ItemRenderInterface;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.event.ItemEvent;
import noppes.npcs.scripted.item.ScriptCustomItem;
import org.lwjgl.opengl.GL11;

public class ItemScripted
extends Item
implements ItemRenderInterface {
    public ItemScripted() {
        this.field_77777_bU = 1;
        this.func_77637_a(CustomItems.tab);
        CustomNpcs.proxy.registerItem(this);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = Items.field_151035_b.func_77617_a(0);
    }

    public int func_82790_a(ItemStack itemStack, int par2) {
        return 9127187;
    }

    public boolean func_77623_v() {
        return true;
    }

    public Item func_77655_b(String name) {
        GameRegistry.registerItem((Item)this, (String)name);
        return super.func_77655_b(name);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af() && player.field_71075_bZ.field_75098_d) {
            if (!ConfigScript.canScript(player, CustomNpcsPermissions.TOOL_SCRIPTED_ITEM)) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("availability.permission", new Object[0]));
            } else {
                CustomNpcs.proxy.openGui(0, 0, 0, EnumGuiType.ScriptItem, player);
            }
        }
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public boolean onEntitySwing(EntityLivingBase entityLivingBase, ItemStack stack) {
        if (entityLivingBase.field_70170_p.field_72995_K) {
            return false;
        }
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent((ScriptCustomItem)istack, NpcAPI.Instance().getIEntity((Entity)entityLivingBase), 2, null);
        return EventHooks.onScriptItemAttack((ScriptCustomItem)istack, eve);
    }

    public int func_77626_a(ItemStack stack) {
        return new ScriptCustomItem(stack).getMaxItemUseDuration();
    }

    public static ScriptCustomItem GetWrapper(ItemStack stack) {
        return new ScriptCustomItem(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        return istack instanceof ScriptCustomItem && new ScriptCustomItem((ItemStack)stack).durabilityShow;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        return istack instanceof ScriptCustomItem ? 1.0 - new ScriptCustomItem((ItemStack)stack).durabilityValue : 1.0;
    }

    public int getItemStackLimit(ItemStack stack) {
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        return istack instanceof ScriptCustomItem ? new ScriptCustomItem(stack).getMaxStackSize() : super.getItemStackLimit(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        return istack instanceof ScriptCustomItem ? new ScriptCustomItem(stack).isTool() : super.func_77616_k(stack);
    }

    public float getDigSpeed(ItemStack stack, Block block, int metadata) {
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        return istack instanceof ScriptCustomItem ? (float)new ScriptCustomItem(stack).getDigSpeed() : super.getDigSpeed(stack, block, metadata);
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        if (new ScriptCustomItem(stack).getArmorType() == -1) {
            return true;
        }
        return istack instanceof ScriptCustomItem ? armorType == new ScriptCustomItem(stack).getArmorType() : super.isValidArmor(stack, armorType, entity);
    }

    public int getItemEnchantability(ItemStack stack) {
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        return istack instanceof ScriptCustomItem ? new ScriptCustomItem(stack).getEnchantability() : super.getItemEnchantability(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent((ScriptCustomItem)istack, NpcAPI.Instance().getIEntity((Entity)attacker), 1, NpcAPI.Instance().getIEntity((Entity)target));
        return EventHooks.onScriptItemAttack((ScriptCustomItem)istack, eve);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        IItemStack istack = NpcAPI.Instance().getIItemStack(stack);
        if (istack instanceof ScriptCustomItem) {
            switch (((ScriptCustomItem)istack).getItemUseAction()) {
                case 0: {
                    return EnumAction.none;
                }
                case 1: {
                    return EnumAction.block;
                }
                case 2: {
                    return EnumAction.bow;
                }
                case 3: {
                    return EnumAction.eat;
                }
                case 4: {
                    return EnumAction.drink;
                }
            }
        }
        return super.func_77661_b(stack);
    }

    @Override
    public void renderSpecial() {
    }

    public void renderOffset(ScriptCustomItem scriptCustomItem) {
        GL11.glTranslatef((float)(0.135f * scriptCustomItem.scaleX), (float)(0.2f * scriptCustomItem.scaleY), (float)(0.07f * scriptCustomItem.scaleZ));
    }
}

