/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.DragonBC.common.mixin;

import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import java.util.HashMap;

public class OfflineTranslator {
    private OrtEnvironment env = OrtEnvironment.getEnvironment();
    private OrtSession session;

    public OfflineTranslator(String modelPath) throws OrtException {
        this.session = this.env.createSession(modelPath, new OrtSession.SessionOptions());
    }

    public String translate(String text) throws OrtException {
        String[] inputTokens = this.tokenize(text);
        OnnxTensor inputTensor = OnnxTensor.createTensor((OrtEnvironment)this.env, (String[])inputTokens, (long[])new long[]{1L, inputTokens.length});
        HashMap<String, OnnxTensor> inputs = new HashMap<String, OnnxTensor>();
        inputs.put("input", inputTensor);
        OrtSession.Result results = this.session.run(inputs);
        String[] translatedTokens = (String[])results.get(0).getValue();
        return this.detokenize(translatedTokens);
    }

    private String[] tokenize(String text) {
        return text.split(" ");
    }

    private String detokenize(String[] tokens) {
        return String.join((CharSequence)" ", tokens);
    }

    public static void main(String[] args) {
        try {
            OfflineTranslator translator = new OfflineTranslator("model/translation-en-pt.onnx");
            String text = "Hello world!";
            String string = translator.translate(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

