/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;
import java.util.Properties;
import org.lwjgl.opengl.GL11;

public class TextureAnimation {
    private String srcTex = null;
    private String dstTex = null;
    bqx dstTexLoc = null;
    private int dstTextId = -1;
    private int dstX = 0;
    private int dstY = 0;
    private int frameWidth = 0;
    private int frameHeight = 0;
    private TextureAnimationFrame[] frames = null;
    private int activeFrame = 0;
    byte[] srcData = null;
    private ByteBuffer imageData = null;

    public TextureAnimation(String texFrom, byte[] srcData, String texTo, bqx locTexTo, int dstX, int dstY, int frameWidth, int frameHeight, Properties props, int durDef) {
        this.srcTex = texFrom;
        this.dstTex = texTo;
        this.dstTexLoc = locTexTo;
        this.dstX = dstX;
        this.dstY = dstY;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        int frameLen = frameWidth * frameHeight * 4;
        if (srcData.length % frameLen != 0) {
            Config.warn("Invalid animated texture length: " + srcData.length + ", frameWidth: " + frameWidth + ", frameHeight: " + frameHeight);
        }
        this.srcData = srcData;
        int numFrames = srcData.length / frameLen;
        if (props.get("tile.0") != null) {
            int i = 0;
            while (props.get("tile." + i) != null) {
                numFrames = i + 1;
                ++i;
            }
        }
        String durationDefStr = (String)props.get("duration");
        int durationDef = Config.parseInt(durationDefStr, durDef);
        this.frames = new TextureAnimationFrame[numFrames];
        for (int i = 0; i < this.frames.length; ++i) {
            TextureAnimationFrame frm;
            String indexStr = (String)props.get("tile." + i);
            int index = Config.parseInt(indexStr, i);
            String durationStr = (String)props.get("duration." + i);
            int duration = Config.parseInt(durationStr, durationDef);
            this.frames[i] = frm = new TextureAnimationFrame(index, duration);
        }
    }

    public boolean nextFrame() {
        if (this.frames.length <= 0) {
            return false;
        }
        if (this.activeFrame >= this.frames.length) {
            this.activeFrame = 0;
        }
        TextureAnimationFrame frame = this.frames[this.activeFrame];
        ++frame.counter;
        if (frame.counter < frame.duration) {
            return false;
        }
        frame.counter = 0;
        ++this.activeFrame;
        if (this.activeFrame >= this.frames.length) {
            this.activeFrame = 0;
        }
        return true;
    }

    public int getActiveFrameIndex() {
        if (this.frames.length <= 0) {
            return 0;
        }
        if (this.activeFrame >= this.frames.length) {
            this.activeFrame = 0;
        }
        TextureAnimationFrame frame = this.frames[this.activeFrame];
        return frame.index;
    }

    public int getFrameCount() {
        return this.frames.length;
    }

    public boolean updateTexture() {
        if (this.dstTextId < 0) {
            bqh tex = TextureUtils.getTexture(this.dstTexLoc);
            if (tex == null) {
                return false;
            }
            this.dstTextId = tex.b();
        }
        if (this.imageData == null) {
            this.imageData = ban.c((int)this.srcData.length);
            this.imageData.put(this.srcData);
            this.srcData = null;
        }
        if (!this.nextFrame()) {
            return false;
        }
        int frameLen = this.frameWidth * this.frameHeight * 4;
        int imgNum = this.getActiveFrameIndex();
        int offset = frameLen * imgNum;
        if (offset + frameLen > this.imageData.capacity()) {
            return false;
        }
        this.imageData.position(offset);
        GlStateManager.bindTexture(this.dstTextId);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)this.dstX, (int)this.dstY, (int)this.frameWidth, (int)this.frameHeight, (int)6408, (int)5121, (ByteBuffer)this.imageData);
        return true;
    }

    public String getSrcTex() {
        return this.srcTex;
    }

    public String getDstTex() {
        return this.dstTex;
    }

    public bqx getDstTexLoc() {
        return this.dstTexLoc;
    }
}

