/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

public class Debug {
    public static double size = 0.0;

    public static void debug(String s) {
        if (s.contains("+")) {
            size += Double.parseDouble(s.split("\\+")[1]);
        }
        if (s.contains("-")) {
            size += Double.parseDouble(s.split("-")[1]);
        }
        if (s.contains(">")) {
            size = Double.parseDouble(s.split(">")[1]);
        }
    }

    public static void debug(String path, Object instance) {
        StringBuilder script = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line;
            while ((line = reader.readLine()) != null) {
                script.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading script file: " + path, e);
        }
        String className = "DebugScript";
        String javaCode = "public class " + className + " {\n    public static void execute(Object instance) {\n        " + script.toString() + "\n    }\n}";
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        JavaSourceFromString file = new JavaSourceFromString(className, javaCode);
        StringWriter writer = new StringWriter();
        boolean success = compiler.getTask(writer, null, null, null, null, Arrays.asList(file)).call();
        if (success) {
            try {
                Class<?> clazz = Class.forName(className);
                Method method = clazz.getMethod("execute", Object.class);
                method.invoke(null, instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error executing script.", e);
            }
        } else {
            throw new RuntimeException("Compilation failed: " + writer.toString());
        }
    }

    static class JavaSourceFromString
    extends SimpleJavaFileObject {
        final String code;

        JavaSourceFromString(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }
}

