/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.after;

import JinRyuu.JRMCore.after.NBTCompressorForge;
import JinRyuu.JRMCore.after.OrderMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CustomMenuGui
extends GuiContainer {
    public String indentifier;
    public String title = "";
    public int size = 9;
    public List<GifLayer> gifLayers = new ArrayList<GifLayer>();
    public List<CustomButton> customButtonList = new ArrayList<CustomButton>();
    public List<SlotFake> slotFakeList = new ArrayList<SlotFake>();
    public List<SlotItem> slotItemList = new ArrayList<SlotItem>();
    public List<StringLayer> stringLayers = new ArrayList<StringLayer>();
    private long lastPacketTime = 0L;

    public void renderStringLayer(StringLayer stringLayer) {
        this.renderString(stringLayer.line, (float)this.field_146294_l / 2.0f - (float)stringLayer.x, (float)this.field_146295_m / 2.0f - (float)stringLayer.y, stringLayer.scale);
    }

    public void renderString(String text, float x, float y, float scale) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        fontRenderer.func_78276_b(text, 0, 0, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    public CustomMenuGui(String indentifier, String title, int size, List<GifLayer> gifLayerList, List<CustomButton> customButtonList, List<SlotFake> slotFakeList, List<SlotItem> slotItemList, List<StringLayer> stringLayers) {
        super((Container)new CustomContainer(title, size, slotFakeList));
        this.indentifier = indentifier;
        this.title = title;
        this.gifLayers = gifLayerList;
        this.customButtonList = customButtonList;
        this.slotFakeList = slotFakeList;
        this.slotItemList = slotItemList;
        this.stringLayers = stringLayers;
    }

    public void updateStringLayers(List<StringLayer> lll2) {
        for (StringLayer stringLayer : lll2) {
            boolean found = false;
            for (StringLayer layer : this.stringLayers) {
                if (stringLayer.id != layer.id) continue;
                this.stringLayers.remove(layer);
                this.stringLayers.add(stringLayer);
                found = true;
                break;
            }
            if (found) continue;
            this.stringLayers.add(stringLayer);
        }
    }

    public void updateGifs(List<GifLayer> lll2) {
        for (GifLayer gifLayer : lll2) {
            boolean found = false;
            for (GifLayer layer : this.gifLayers) {
                if (gifLayer.id != layer.id) continue;
                this.gifLayers.remove(layer);
                this.gifLayers.add(gifLayer);
                found = true;
                break;
            }
            if (found) continue;
            this.gifLayers.add(gifLayer);
        }
        Collections.sort(this.gifLayers, Comparator.comparingInt(g -> g.id));
    }

    public void updateItems(List<SlotItem> slotItems) {
        List slots = this.field_147002_h.field_75151_b;
        for (SlotItem slotItem : slotItems) {
            int id = slotItem.id_slot;
            if (id < 0 || id >= slots.size()) continue;
            Slot slot = (Slot)slots.get(id);
            if (slotItem.bytes.length > 4) {
                try {
                    ItemStack mmm = NBTCompressorForge.decompressItemStack(slotItem.bytes);
                    slot.func_75215_d(mmm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            slot.func_75215_d(null);
        }
    }

    public void updateItems() {
        this.updateItems(this.slotItemList);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (CustomButton customButton : this.customButtonList) {
            this.field_146292_n.add(customButton);
        }
        this.updateItems();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        for (GifLayer gifLayer : this.gifLayers) {
            if (gifLayer.FRAME_DURATION <= 0) continue;
            this.renderGif(gifLayer, this.field_146294_l / 2, this.field_146295_m / 2, gifLayer.width, gifLayer.height);
        }
        for (StringLayer stringLayer : this.stringLayers) {
            this.renderStringLayer(stringLayer);
        }
    }

    private void renderGif(GifLayer gifLayer, int x, int y, int width, int height) {
        long currentTime = System.currentTimeMillis();
        x += gifLayer.x;
        y += gifLayer.y;
        if (currentTime - gifLayer.lastFrameTime >= (long)gifLayer.FRAME_DURATION) {
            gifLayer.currentFrame++;
            if (gifLayer.currentFrame >= gifLayer.gifFrames.size()) {
                if (gifLayer.loop) {
                    gifLayer.currentFrame = 0;
                } else {
                    gifLayer.currentFrame = gifLayer.gifFrames.size() - 1;
                    if (gifLayer.callback != null) {
                        gifLayer.callback.run();
                    }
                }
            }
            gifLayer.lastFrameTime = currentTime;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2929);
        ResourceLocation currentFrameTexture = gifLayer.gifFrames.get(gifLayer.currentFrame);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(currentFrameTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)((float)width / 256.0f), (float)((float)height / 256.0f), (float)1.0f);
        this.func_73729_b(0, 0, 0, 0, 256, 256);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
    }

    private Slot getSlotAtPositionf(int p_146975_1_, int p_146975_2_) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlotfff(slot, p_146975_1_, p_146975_2_)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlotfff(Slot p_146981_1_, int p_146981_2_, int p_146981_3_) {
        return this.fff(p_146981_1_.field_75223_e, p_146981_1_.field_75221_f, 16, 16, p_146981_2_, p_146981_3_);
    }

    protected boolean fff(int p_146978_1_, int p_146978_2_, int p_146978_3_, int p_146978_4_, int p_146978_5_, int p_146978_6_) {
        int k1 = this.field_147003_i;
        int l1 = this.field_147009_r;
        return (p_146978_5_ -= k1) >= p_146978_1_ - 1 && p_146978_5_ < p_146978_1_ + p_146978_3_ + 1 && (p_146978_6_ -= l1) >= p_146978_2_ - 1 && p_146978_6_ < p_146978_2_ + p_146978_4_ + 1;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }

    protected void func_146984_a(Slot slot, int p_146984_2_, int p_146984_3_, int p_146984_4_) {
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        long currentTime;
        Slot slot = this.getSlotAtPositionf(mouseX, mouseY);
        if (slot != null && (currentTime = System.currentTimeMillis()) - this.lastPacketTime >= 200L) {
            OrderMenu.sendPacketSlotClick(this.title, slot.field_75222_d);
            this.lastPacketTime = currentTime;
        }
    }

    private static class FakeInventory
    extends InventoryBasic {
        public FakeInventory(String title, int size) {
            super(title, false, size);
        }
    }

    private static class CustomContainer
    extends Container {
        public String title;

        public CustomContainer(String title, int size, List<SlotFake> slotFakeList) {
            this.title = title;
            FakeInventory fakeInventory = new FakeInventory(title, size);
            for (SlotFake slotFake : slotFakeList) {
                this.func_75146_a(new Slot((IInventory)fakeInventory, slotFake.id, slotFake.x, slotFake.y));
            }
        }

        public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
            return null;
        }

        public ItemStack func_75144_a(int slotId, int dragType, int clickType, EntityPlayer player) {
            if (slotId < 0 || slotId < this.field_75151_b.size()) {
                // empty if block
            }
            return null;
        }

        public void func_75141_a(int slotID, ItemStack stack) {
        }

        public void func_75131_a(ItemStack[] stacks) {
        }

        public void func_75134_a(EntityPlayer player) {
        }

        public void func_75142_b() {
        }

        public boolean func_94530_a(ItemStack stack, Slot slot) {
            return false;
        }

        protected void func_75133_b(int slotId, int clickedButton, boolean mode, EntityPlayer player) {
        }

        public void func_75130_a(IInventory inventory) {
        }

        public void func_75132_a(ICrafting listener) {
        }

        public boolean func_75145_c(EntityPlayer p_75145_1_) {
            return false;
        }
    }

    public static class CustomButton
    extends GuiButton {
        public final ResourceLocation normalTexture;
        public final ResourceLocation hoverTexture;
        public int x;
        public int y;
        private final Consumer<Integer> onClick;

        public CustomButton(int id, int x, int y, int width, int height, ResourceLocation normalTexture, ResourceLocation hoverTexture, Consumer<Integer> onClick) {
            super(id, x, y, width, height, "");
            this.x = x;
            this.y = y;
            this.normalTexture = normalTexture;
            this.hoverTexture = hoverTexture;
            this.onClick = onClick;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
                if (guiScreen != null) {
                    this.field_146128_h = guiScreen.field_146294_l / 2 + this.x;
                    this.field_146129_i = guiScreen.field_146295_m / 2 + this.y;
                }
                boolean isHovered = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                mc.func_110434_K().func_110577_a(isHovered ? this.hoverTexture : this.normalTexture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
                GL11.glScalef((float)((float)this.field_146120_f / 256.0f), (float)((float)this.field_146121_g / 256.0f), (float)1.0f);
                this.func_73729_b(0, 0, 0, 0, 256, 256);
                GL11.glPopMatrix();
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                if (this.onClick != null) {
                    this.onClick.accept(this.field_146127_k);
                }
                return true;
            }
            return false;
        }
    }

    public static class GifLayer {
        public List<ResourceLocation> gifFrames = new ArrayList<ResourceLocation>();
        public int FRAME_DURATION = 100;
        public boolean loop = true;
        private Runnable callback = new Runnable(){

            @Override
            public void run() {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("GIF terminou!"));
            }
        };
        private int currentFrame = 0;
        private long lastFrameTime = 0L;
        public int id;
        public int x;
        public int y;
        public int width;
        public int height;

        public GifLayer(int id, int x, int y, int width, int height, List<ResourceLocation> gifFrames, int FRAME_DURATION, boolean loop, Runnable callback) {
            this.id = id;
            this.gifFrames = gifFrames;
            this.FRAME_DURATION = FRAME_DURATION;
            this.loop = loop;
            this.callback = callback;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void setLoop(boolean loop) {
            this.loop = loop;
        }

        public void setCallback(Runnable callback) {
            this.callback = callback;
        }
    }

    public static class SlotItem {
        public int id_slot;
        public byte[] bytes;

        public SlotItem(int id_slot, byte[] bytes) {
            this.id_slot = id_slot;
            this.bytes = bytes;
        }
    }

    public static class StringLayer {
        public int id;
        public String line;
        public int x;
        public int y;
        public float scale;

        public StringLayer(int id, String line, int x, int y, float scale) {
            this.id = id;
            this.line = line.replace("&", "\u00a7");
            this.x = x;
            this.y = y;
            this.scale = scale;
        }
    }

    public static class SlotFake {
        public int id;
        public int x;
        public int y;

        public SlotFake(int id, int x, int y) {
            this.id = id;
            this.x = x;
            this.y = y;
        }
    }
}

