/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.after;

import JinRyuu.JRMCore.after.CustomMenuGui;
import JinRyuu.JRMCore.after.PacketClickButtonMenu;
import JinRyuu.JRMCore.after.PacketClickSlotMenu;
import JinRyuu.JRMCore.after.PacketRandomInfo;
import JinRyuu.JRMCore.p.PD;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class OrderMenu {
    public static boolean SEND_RANDOM = false;

    public static void writeToBuffer(CustomMenuGui customMenuGui, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)customMenuGui.indentifier);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)customMenuGui.title);
        buf.writeInt(customMenuGui.size);
        OrderMenu.writeBuffGifLayer(buf, customMenuGui.gifLayers);
        buf.writeInt(customMenuGui.customButtonList.size());
        for (CustomMenuGui.CustomButton customButton : customMenuGui.customButtonList) {
            buf.writeInt(customButton.field_146127_k);
            buf.writeInt(customButton.x);
            buf.writeInt(customButton.y);
            buf.writeInt(customButton.field_146120_f);
            buf.writeInt(customButton.field_146121_g);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)customButton.normalTexture.toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)customButton.hoverTexture.toString());
        }
        buf.writeInt(customMenuGui.slotFakeList.size());
        for (CustomMenuGui.SlotFake slotFake : customMenuGui.slotFakeList) {
            buf.writeInt(slotFake.id);
            buf.writeInt(slotFake.x);
            buf.writeInt(slotFake.y);
        }
        OrderMenu.writeBuffSlotItem(buf, customMenuGui.slotItemList);
        OrderMenu.writeBufferStringLayer(buf, customMenuGui.stringLayers);
    }

    public static void writeBuffGifLayer(ByteBuf buf, List<CustomMenuGui.GifLayer> gifLayers) {
        buf.writeInt(gifLayers.size());
        for (CustomMenuGui.GifLayer gifLayer : gifLayers) {
            buf.writeInt(gifLayer.id);
            buf.writeInt(gifLayer.x);
            buf.writeInt(gifLayer.y);
            buf.writeInt(gifLayer.width);
            buf.writeInt(gifLayer.height);
            buf.writeInt(gifLayer.gifFrames.size());
            for (ResourceLocation frame : gifLayer.gifFrames) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)frame.toString());
            }
            buf.writeInt(gifLayer.FRAME_DURATION);
            buf.writeBoolean(gifLayer.loop);
        }
    }

    public static void writeBuffSlotItem(ByteBuf buf, List<CustomMenuGui.SlotItem> slotItemList) {
        buf.writeInt(slotItemList.size());
        for (CustomMenuGui.SlotItem slotItem : slotItemList) {
            buf.writeInt(slotItem.id_slot);
            buf.writeInt(slotItem.bytes.length);
            buf.writeBytes(slotItem.bytes);
        }
    }

    public static CustomMenuGui readFromBuffer(ByteBuf buf) {
        try {
            String indentifier = "";
            String title = "";
            int size = 9;
            ArrayList<CustomMenuGui.GifLayer> gifLayers = new ArrayList();
            ArrayList<CustomMenuGui.CustomButton> buttonsLayers = new ArrayList<CustomMenuGui.CustomButton>();
            ArrayList<CustomMenuGui.SlotFake> slotFakeList = new ArrayList<CustomMenuGui.SlotFake>();
            ArrayList<CustomMenuGui.SlotItem> slotItemList = new ArrayList();
            ArrayList<CustomMenuGui.StringLayer> stringLayeList = new ArrayList();
            indentifier = ByteBufUtils.readUTF8String((ByteBuf)buf);
            title = ByteBufUtils.readUTF8String((ByteBuf)buf);
            size = buf.readInt();
            gifLayers = OrderMenu.readBufferGifLayer(buf);
            int buttonLayerCount = buf.readInt();
            for (int i = 0; i < buttonLayerCount; ++i) {
                int id = buf.readInt();
                int x = buf.readInt();
                int y = buf.readInt();
                int width = buf.readInt();
                int height = buf.readInt();
                String normalTextureHash = ByteBufUtils.readUTF8String((ByteBuf)buf);
                String hoverTextureHash = ByteBufUtils.readUTF8String((ByteBuf)buf);
                ResourceLocation normalTexture = new ResourceLocation(normalTextureHash);
                ResourceLocation hoverTexture = new ResourceLocation(hoverTextureHash);
                String finalTitle = title;
                buttonsLayers.add(new CustomMenuGui.CustomButton(id, x, y, width, height, normalTexture, hoverTexture, integer -> OrderMenu.sendPacketButtonClick(finalTitle, integer)));
            }
            int slotFakeCount = buf.readInt();
            for (int i = 0; i < slotFakeCount; ++i) {
                int id = buf.readInt();
                int x = buf.readInt();
                int y = buf.readInt();
                slotFakeList.add(new CustomMenuGui.SlotFake(id, x, y));
            }
            slotItemList = OrderMenu.readBuffSlotItem(buf);
            stringLayeList = OrderMenu.readBufferStringLayer(buf);
            return new CustomMenuGui(indentifier, title, size, gifLayers, buttonsLayers, slotFakeList, slotItemList, stringLayeList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<CustomMenuGui.GifLayer> readBufferGifLayer(ByteBuf buf) {
        ArrayList<CustomMenuGui.GifLayer> gifLayers = new ArrayList<CustomMenuGui.GifLayer>();
        int gifLayerCount = buf.readInt();
        for (int i = 0; i < gifLayerCount; ++i) {
            int id = buf.readInt();
            int x = buf.readInt();
            int y = buf.readInt();
            int width = buf.readInt();
            int height = buf.readInt();
            int frameCount = buf.readInt();
            ArrayList<ResourceLocation> gifFrames = new ArrayList<ResourceLocation>();
            for (int j = 0; j < frameCount; ++j) {
                String frameHash = ByteBufUtils.readUTF8String((ByteBuf)buf);
                gifFrames.add(new ResourceLocation(frameHash));
            }
            int FRAME_DURATION = buf.readInt();
            boolean loop = buf.readBoolean();
            gifLayers.add(new CustomMenuGui.GifLayer(id, x, y, width, height, gifFrames, FRAME_DURATION, loop, new Runnable(){

                @Override
                public void run() {
                }
            }));
        }
        Collections.sort(gifLayers, Comparator.comparingInt(g -> g.id));
        return gifLayers;
    }

    public static List<CustomMenuGui.SlotItem> readBuffSlotItem(ByteBuf buf) {
        ArrayList<CustomMenuGui.SlotItem> slotItemList = new ArrayList<CustomMenuGui.SlotItem>();
        int slotItemCount = buf.readInt();
        for (int i = 0; i < slotItemCount; ++i) {
            int id_slot = buf.readInt();
            int length = buf.readInt();
            byte[] byteArray = new byte[length];
            buf.readBytes(byteArray);
            slotItemList.add(new CustomMenuGui.SlotItem(id_slot, byteArray));
        }
        return slotItemList;
    }

    public static void sendPacketButtonClick(String title, int id) {
        PD.sendToServer(new PacketClickButtonMenu(title, id));
    }

    public static void sendPacketSlotClick(String title, int slot) {
        PD.sendToServer(new PacketClickSlotMenu(title, slot));
    }

    public static void writeBufferStringLayer(ByteBuf buf, List<CustomMenuGui.StringLayer> stringLayerList) {
        buf.writeInt(stringLayerList.size());
        for (CustomMenuGui.StringLayer stringLayer : stringLayerList) {
            buf.writeInt(stringLayer.id);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)stringLayer.line);
            buf.writeInt(stringLayer.x);
            buf.writeInt(stringLayer.y);
            buf.writeFloat(stringLayer.scale);
        }
    }

    public static List<CustomMenuGui.StringLayer> readBufferStringLayer(ByteBuf buf) {
        ArrayList<CustomMenuGui.StringLayer> stringLayers = new ArrayList<CustomMenuGui.StringLayer>();
        int stringLayerCount = buf.readInt();
        for (int i = 0; i < stringLayerCount; ++i) {
            int id = buf.readInt();
            String line = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int x = buf.readInt();
            int y = buf.readInt();
            float scale = buf.readFloat();
            stringLayers.add(new CustomMenuGui.StringLayer(id, line, x, y, scale));
        }
        return stringLayers;
    }

    public static void sendPacketRandomToServer(String l) {
        if (SEND_RANDOM) {
            PD.sendToServer(new PacketRandomInfo(l));
        }
    }
}

