/*
 * Decompiled with CFR 0.152.
 */
package JinRyuu.JRMCore.mixin;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={RenderItem.class}, remap=false)
public class MixinRenderItem {
    private static Field cachedRenderWithColorField;
    private static Field cachedZLevelField;
    private static Field cachedRandomField;
    private static Field cachedRenderBlocksField;

    private static Field findFieldOfTypeCached(Class<?> owner, Class<?> type, Field cacheHolder) {
        if (cacheHolder != null) {
            return cacheHolder;
        }
        for (Field f : owner.getDeclaredFields()) {
            if (!type.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            return f;
        }
        return null;
    }

    private boolean getRenderWithColor() {
        try {
            Object val;
            if (cachedRenderWithColorField == null && (cachedRenderWithColorField = MixinRenderItem.findFieldOfTypeCached(RenderItem.class, Boolean.TYPE, cachedRenderWithColorField)) == null) {
                for (Field f : RenderItem.class.getDeclaredFields()) {
                    if (f.getType() != Boolean.TYPE && f.getType() != Boolean.class) continue;
                    f.setAccessible(true);
                    cachedRenderWithColorField = f;
                    break;
                }
            }
            if (cachedRenderWithColorField != null && (val = cachedRenderWithColorField.get(this)) instanceof Boolean) {
                return (Boolean)val;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    private float getZLevel() {
        try {
            if (cachedZLevelField == null && (cachedZLevelField = MixinRenderItem.findFieldOfTypeCached(RenderItem.class, Float.TYPE, cachedZLevelField)) == null) {
                for (Field f : RenderItem.class.getDeclaredFields()) {
                    if (f.getType() != Float.TYPE && f.getType() != Float.class) continue;
                    f.setAccessible(true);
                    cachedZLevelField = f;
                    break;
                }
            }
            if (cachedZLevelField != null) {
                Object val = cachedZLevelField.get(this);
                if (val instanceof Float) {
                    return ((Float)val).floatValue();
                }
                if (val instanceof Number) {
                    return ((Number)val).floatValue();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return 0.0f;
    }

    private Random getRandom() {
        try {
            Object val;
            if (cachedRandomField == null) {
                cachedRandomField = MixinRenderItem.findFieldOfTypeCached(RenderItem.class, Random.class, cachedRandomField);
            }
            if (cachedRandomField != null && (val = cachedRandomField.get(this)) instanceof Random) {
                return (Random)val;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new Random();
    }

    private RenderBlocks getRenderBlocks() {
        try {
            Field[] fields;
            for (Field f : fields = RenderItem.class.getDeclaredFields()) {
                if (!RenderBlocks.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                Object val = f.get(this);
                if (!(val instanceof RenderBlocks)) continue;
                return (RenderBlocks)val;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new RenderBlocks();
    }

    @Overwrite
    public void renderItemIntoGUI(FontRenderer p_77015_1_, TextureManager p_77015_2_, @NotNull ItemStack p_77015_3_, int p_77015_4_, int p_77015_5_, boolean renderEffect) {
        int k = p_77015_3_.func_77960_j();
        IIcon object = p_77015_3_.func_77954_c();
        if (p_77015_3_.func_77973_b() == Items.field_151144_bL) {
            GameProfile gameprofile = null;
            if (p_77015_3_.func_77942_o()) {
                NBTTagCompound nbttagcompound = p_77015_3_.func_77978_p();
                if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                    gameprofile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("SkullOwner"));
                } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && !StringUtils.func_151246_b((String)nbttagcompound.func_74779_i("SkullOwner"))) {
                    gameprofile = new GameProfile((UUID)null, nbttagcompound.func_74779_i("SkullOwner"));
                }
            }
            float yaw = -60.0f;
            float pitch = -180.0f;
            float roll = 0.0f;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)24640);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.5f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslatef((float)(p_77015_4_ - 3), (float)(p_77015_5_ + 3 + 15), (float)(-3.0f + this.getZLevel()));
            GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
            GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)roll, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glEnable((int)32826);
            GL11.glScalef((float)20.0f, (float)20.0f, (float)20.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2903);
            GL11.glShadeModel((int)7425);
            RenderHelper.func_74519_b();
            int maxLight = 0xF000F0;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(maxLight % 65536), (float)(maxLight / 65536));
            TileEntitySkullRenderer.field_147536_b.func_152674_a(0.0f, 0.0f, 0.0f, 0, 0.0f, 3, gameprofile);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2903);
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)32826);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        } else if (p_77015_3_.func_94608_d() == 0 && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)p_77015_3_.func_77973_b()).func_149645_b())) {
            p_77015_2_.func_110577_a(TextureMap.field_110575_b);
            Block block = Block.func_149634_a((Item)p_77015_3_.func_77973_b());
            GL11.glEnable((int)3008);
            if (block.func_149701_w() != 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            } else {
                GL11.glAlphaFunc((int)516, (float)0.5f);
                GL11.glDisable((int)3042);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(p_77015_4_ - 2), (float)(p_77015_5_ + 3), (float)(-3.0f + this.getZLevel()));
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int l = p_77015_3_.func_77973_b().func_82790_a(p_77015_3_, 0);
            float f3 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f = (float)(l & 0xFF) / 255.0f;
            if (this.getRenderWithColor()) {
                GL11.glColor4f((float)f3, (float)f4, (float)f, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.getRenderBlocks().field_147844_c = this.getRenderWithColor();
            this.getRenderBlocks().func_147800_a(block, k, 1.0f);
            this.getRenderBlocks().field_147844_c = true;
            if (block.func_149701_w() == 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
            GL11.glPopMatrix();
        } else if (p_77015_3_.func_77973_b().func_77623_v()) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            p_77015_2_.func_110577_a(TextureMap.field_110576_c);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)0, (int)0, (int)0, (int)0);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78378_d(-1);
            tessellator.func_78377_a((double)(p_77015_4_ - 2), (double)(p_77015_5_ + 18), (double)this.getZLevel());
            tessellator.func_78377_a((double)(p_77015_4_ + 18), (double)(p_77015_5_ + 18), (double)this.getZLevel());
            tessellator.func_78377_a((double)(p_77015_4_ + 18), (double)(p_77015_5_ - 2), (double)this.getZLevel());
            tessellator.func_78377_a((double)(p_77015_4_ - 2), (double)(p_77015_5_ - 2), (double)this.getZLevel());
            tessellator.func_78381_a();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
            Item item = p_77015_3_.func_77973_b();
            for (int l = 0; l < item.getRenderPasses(k); ++l) {
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                p_77015_2_.func_110577_a(item.func_94901_k() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
                IIcon iicon = item.getIcon(p_77015_3_, l);
                int i1 = p_77015_3_.func_77973_b().func_82790_a(p_77015_3_, l);
                float f = (float)(i1 >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i1 >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i1 & 0xFF) / 255.0f;
                if (this.getRenderWithColor()) {
                    GL11.glColor4f((float)f, (float)f1, (float)f2, (float)1.0f);
                }
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3008);
                ((RenderItem)this).func_94149_a(p_77015_4_, p_77015_5_, iicon, 16, 16);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)2896);
                if (!renderEffect || !p_77015_3_.hasEffect(l)) continue;
                ((RenderItem)this).renderEffect(p_77015_2_, p_77015_4_, p_77015_5_);
            }
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            ResourceLocation resourcelocation = p_77015_2_.func_130087_a(p_77015_3_.func_94608_d());
            p_77015_2_.func_110577_a(resourcelocation);
            if (object == null) {
                object = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(resourcelocation)).func_110572_b("missingno");
            }
            int l = p_77015_3_.func_77973_b().func_82790_a(p_77015_3_, 0);
            float f3 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f = (float)(l & 0xFF) / 255.0f;
            if (this.getRenderWithColor()) {
                GL11.glColor4f((float)f3, (float)f4, (float)f, (float)1.0f);
            }
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            ((RenderItem)this).func_94149_a(p_77015_4_, p_77015_5_, object, 16, 16);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3042);
            if (renderEffect && p_77015_3_.hasEffect(0)) {
                ((RenderItem)this).renderEffect(p_77015_2_, p_77015_4_, p_77015_5_);
            }
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
    }
}

