/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

abstract class CommandBase
implements CommandExecutor {
    public static final ReportType REPORT_COMMAND_ERROR = new ReportType("Cannot execute command %s.");
    public static final ReportType REPORT_UNEXPECTED_COMMAND = new ReportType("Incorrect command assigned to %s.");
    public static final String PERMISSION_ADMIN = "protocol.admin";
    private String permission;
    private String name;
    private int minimumArgumentCount;
    protected ErrorReporter reporter;

    public CommandBase(ErrorReporter reporter, String permission, String name) {
        this(reporter, permission, name, 0);
    }

    public CommandBase(ErrorReporter reporter, String permission, String name, int minimumArgumentCount) {
        this.reporter = reporter;
        this.name = name;
        this.permission = permission;
        this.minimumArgumentCount = minimumArgumentCount;
    }

    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        try {
            if (!command.getName().equalsIgnoreCase(this.name)) {
                this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_UNEXPECTED_COMMAND).messageParam(this));
                return false;
            }
            if (this.permission != null && !sender.hasPermission(this.permission)) {
                sender.sendMessage(ChatColor.RED + "You haven't got permission to run this command.");
                return true;
            }
            if (args != null && args.length >= this.minimumArgumentCount) {
                return this.handleCommand(sender, args);
            }
            sender.sendMessage(ChatColor.RED + "Insufficient commands. You need at least " + this.minimumArgumentCount);
            return false;
        }
        catch (Exception e) {
            this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_COMMAND_ERROR).error(e).messageParam(this.name).callerParam(sender, label, args));
            return true;
        }
    }

    protected Boolean parseBoolean(Deque<String> arguments, String parameterName) {
        Boolean result = null;
        if (!arguments.isEmpty()) {
            String arg = arguments.peek();
            if (arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("on")) {
                result = true;
            } else if (arg.equalsIgnoreCase(parameterName)) {
                result = true;
            } else if (arg.equalsIgnoreCase("false") || arg.equalsIgnoreCase("off")) {
                result = false;
            }
        }
        if (result != null) {
            arguments.poll();
        }
        return result;
    }

    protected Deque<String> toQueue(String[] args, int start) {
        return new ArrayDeque<String>(Arrays.asList(args).subList(start, args.length));
    }

    public String getPermission() {
        return this.permission;
    }

    public String getName() {
        return this.name;
    }

    protected ErrorReporter getReporter() {
        return this.reporter;
    }

    protected abstract boolean handleCommand(CommandSender var1, String[] var2);
}

