/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import com.comphenix.protocol.injector.netty.ChannelInjector;
import com.comphenix.protocol.injector.netty.ChannelListener;
import com.comphenix.protocol.injector.netty.ClosedInjector;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.server.SocketInjector;
import com.comphenix.protocol.injector.server.TemporaryPlayerFactory;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.utility.MinecraftFields;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import net.minecraft.util.io.netty.channel.Channel;
import net.minecraft.util.io.netty.channel.ChannelHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class InjectionFactory {
    private final ConcurrentMap<Player, Injector> playerLookup = new MapMaker().weakKeys().weakValues().makeMap();
    private final ConcurrentMap<String, Injector> nameLookup = new MapMaker().weakValues().makeMap();
    private volatile boolean closed;
    private final Plugin plugin;

    public InjectionFactory(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Nonnull
    public Injector fromPlayer(Player player, ChannelListener listener) {
        if (this.closed) {
            return new ClosedInjector(player);
        }
        Injector injector = (Injector)this.playerLookup.get(player);
        if (injector == null) {
            injector = this.getTemporaryInjector(player);
        }
        if (injector != null && !injector.isClosed()) {
            return injector;
        }
        Object networkManager = MinecraftFields.getNetworkManager(player);
        if (networkManager == null) {
            return this.fromName(player.getName(), player);
        }
        Channel channel = FuzzyReflection.getFieldValue(networkManager, Channel.class, true);
        injector = (ChannelInjector)ChannelInjector.findChannelHandler(channel, ChannelInjector.class);
        if (injector != null) {
            this.playerLookup.remove(injector.getPlayer());
            injector.setPlayer(player);
        } else {
            injector = new ChannelInjector(player, networkManager, channel, listener, this);
        }
        this.cacheInjector(player, injector);
        return injector;
    }

    public Injector fromName(String name, Player player) {
        Injector injector;
        if (!this.closed && (injector = (Injector)this.nameLookup.get(name)) != null) {
            injector.setUpdatedPlayer(player);
            return injector;
        }
        return new ClosedInjector(player);
    }

    @Nonnull
    public Injector fromChannel(Channel channel, ChannelListener listener, TemporaryPlayerFactory playerFactory) {
        if (this.closed) {
            return new ClosedInjector(null);
        }
        Object networkManager = this.findNetworkManager(channel);
        Player temporaryPlayer = playerFactory.createTemporaryPlayer(Bukkit.getServer());
        ChannelInjector injector = new ChannelInjector(temporaryPlayer, networkManager, channel, listener, this);
        TemporaryPlayerFactory.setInjectorInPlayer(temporaryPlayer, new ChannelInjector.ChannelSocketInjector(injector));
        return injector;
    }

    public Injector invalidate(Player player) {
        Injector injector = (Injector)this.playerLookup.remove(player);
        this.nameLookup.remove(player.getName());
        return injector;
    }

    public Injector cacheInjector(Player player, Injector injector) {
        this.nameLookup.put(player.getName(), injector);
        return this.playerLookup.put(player, injector);
    }

    public Injector cacheInjector(String name, Injector injector) {
        return this.nameLookup.put(name, injector);
    }

    private ChannelInjector getTemporaryInjector(Player player) {
        SocketInjector injector = TemporaryPlayerFactory.getInjectorFromPlayer(player);
        if (injector != null) {
            return ((ChannelInjector.ChannelSocketInjector)injector).getChannelInjector();
        }
        return null;
    }

    private Object findNetworkManager(Channel channel) {
        ChannelHandler networkManager = ChannelInjector.findChannelHandler(channel, MinecraftReflection.getNetworkManagerClass());
        if (networkManager != null) {
            return networkManager;
        }
        throw new IllegalArgumentException("Unable to find NetworkManager in " + channel);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            for (Injector injector : this.playerLookup.values()) {
                injector.close();
            }
            for (Injector injector : this.nameLookup.values()) {
                injector.close();
            }
        }
    }
}

