/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.annotations.Spigot;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.ReadOnlyFieldAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.TroveWrapper;
import com.comphenix.protocol.wrappers.WrappedChunkCoordinate;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.collection.ConvertedMap;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class WrappedDataWatcher
extends AbstractWrapper
implements Iterable<WrappedWatchableObject> {
    private static Map<Class<?>, Integer> TYPE_MAP;
    private static Map<Class<?>, Integer> CUSTOM_MAP;
    private static FieldAccessor TYPE_MAP_ACCESSOR;
    private static FieldAccessor VALUE_MAP_ACCESSOR;
    private static Field READ_WRITE_LOCK_FIELD;
    private static Field ENTITY_FIELD;
    private static Method CREATE_KEY_VALUE_METHOD;
    private static Method UPDATE_KEY_VALUE_METHOD;
    private static Method GET_KEY_VALUE_METHOD;
    private static Constructor<?> CREATE_DATA_WATCHER_CONSTRUCTOR;
    private static volatile Field ENTITY_DATA_FIELD;
    private static boolean HAS_INITIALIZED;
    private ReadWriteLock readWriteLock;
    private Map<Integer, Object> watchableObjects;
    private Map<Integer, WrappedWatchableObject> mapView;

    public WrappedDataWatcher() {
        super(MinecraftReflection.getDataWatcherClass());
        try {
            if (MinecraftReflection.isUsingNetty()) {
                this.setHandle(WrappedDataWatcher.newEntityHandle(null));
            } else {
                this.setHandle(this.getHandleType().newInstance());
            }
            WrappedDataWatcher.initialize();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to construct DataWatcher.", e);
        }
    }

    public WrappedDataWatcher(Object handle) {
        super(MinecraftReflection.getDataWatcherClass());
        this.setHandle(handle);
        WrappedDataWatcher.initialize();
    }

    public static WrappedDataWatcher newWithEntity(Entity entity) {
        if (!MinecraftReflection.isUsingNetty()) {
            return new WrappedDataWatcher();
        }
        return new WrappedDataWatcher(WrappedDataWatcher.newEntityHandle(entity));
    }

    private static Object newEntityHandle(Entity entity) {
        Class<?> dataWatcher = MinecraftReflection.getDataWatcherClass();
        try {
            if (CREATE_DATA_WATCHER_CONSTRUCTOR == null) {
                CREATE_DATA_WATCHER_CONSTRUCTOR = dataWatcher.getConstructor(MinecraftReflection.getEntityClass());
            }
            return CREATE_DATA_WATCHER_CONSTRUCTOR.newInstance(BukkitUnwrapper.getInstance().unwrapItem(entity));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct data watcher.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WrappedDataWatcher(List<WrappedWatchableObject> watchableObjects) throws FieldAccessException {
        this();
        Lock writeLock = this.getReadWriteLock().writeLock();
        Map<Integer, Object> map = this.getWatchableObjectMap();
        writeLock.lock();
        try {
            for (WrappedWatchableObject watched : watchableObjects) {
                map.put(watched.getIndex(), watched.handle);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static Integer getTypeID(Class<?> clazz) throws FieldAccessException {
        WrappedDataWatcher.initialize();
        Integer result = TYPE_MAP.get(WrappedWatchableObject.getUnwrappedType(clazz));
        if (result == null) {
            result = CUSTOM_MAP.get(clazz);
        }
        return result;
    }

    public static Class<?> getTypeClass(int id) throws FieldAccessException {
        WrappedDataWatcher.initialize();
        for (Map.Entry<Class<?>, Integer> entry : TYPE_MAP.entrySet()) {
            if (!Objects.equal((Object)entry.getValue(), (Object)id)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Byte getByte(int index) throws FieldAccessException {
        return (Byte)this.getObject(index);
    }

    public Short getShort(int index) throws FieldAccessException {
        return (Short)this.getObject(index);
    }

    public Integer getInteger(int index) throws FieldAccessException {
        return (Integer)this.getObject(index);
    }

    public Float getFloat(int index) throws FieldAccessException {
        return (Float)this.getObject(index);
    }

    public String getString(int index) throws FieldAccessException {
        return (String)this.getObject(index);
    }

    public ItemStack getItemStack(int index) throws FieldAccessException {
        return (ItemStack)this.getObject(index);
    }

    public WrappedChunkCoordinate getChunkCoordinate(int index) throws FieldAccessException {
        return (WrappedChunkCoordinate)this.getObject(index);
    }

    public Object getObject(int index) throws FieldAccessException {
        WrappedWatchableObject object = this.getWrappedObject(index);
        return object != null ? object.getValue() : null;
    }

    @Spigot(minimumBuild=1628)
    public WrappedWatchableObject getWrappedObject(int index) {
        Object watchable = this.getWatchedObject(index);
        if (watchable != null) {
            return new WrappedWatchableObject(watchable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WrappedWatchableObject> getWatchableObjects() throws FieldAccessException {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            ArrayList<WrappedWatchableObject> result = new ArrayList<WrappedWatchableObject>();
            for (Object watchable : this.getWatchableObjectMap().values()) {
                if (watchable != null) {
                    result.add(new WrappedWatchableObject(watchable));
                    continue;
                }
                result.add(null);
            }
            ArrayList<WrappedWatchableObject> arrayList = result;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WrappedDataWatcher) {
            WrappedDataWatcher other = (WrappedDataWatcher)obj;
            Iterator<WrappedWatchableObject> first = this.iterator();
            Iterator<WrappedWatchableObject> second = other.iterator();
            if (this.size() != other.size()) {
                return false;
            }
            while (first.hasNext() && second.hasNext()) {
                if (first.next().equals(second.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getWatchableObjects().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> indexSet() throws FieldAccessException {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            HashSet<Integer> hashSet = new HashSet<Integer>(this.getWatchableObjectMap().keySet());
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    public WrappedDataWatcher deepClone() {
        WrappedDataWatcher clone = new WrappedDataWatcher();
        for (WrappedWatchableObject watchable : this) {
            clone.setObject(watchable.getIndex(), watchable.getClonedValue());
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() throws FieldAccessException {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.getWatchableObjectMap().size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WrappedWatchableObject removeObject(int index) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            Object removed = this.getWatchableObjectMap().remove(index);
            WrappedWatchableObject wrappedWatchableObject = removed != null ? new WrappedWatchableObject(removed) : null;
            return wrappedWatchableObject;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void setObject(int index, Object newValue) throws FieldAccessException {
        this.setObject(index, newValue, true);
    }

    public void setObject(int index, Object newValue, boolean update) throws FieldAccessException {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            Object watchable = this.getWatchedObject(index);
            if (watchable != null) {
                new WrappedWatchableObject(watchable).setValue(newValue, update);
            } else {
                CREATE_KEY_VALUE_METHOD.invoke(this.handle, index, WrappedWatchableObject.getUnwrapped(newValue));
            }
        }
        catch (IllegalArgumentException e) {
            throw new FieldAccessException("Cannot convert arguments.", e);
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException("Illegal access.", e);
        }
        catch (InvocationTargetException e) {
            throw new FieldAccessException("Checked exception in Minecraft.", e);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Spigot(minimumBuild=1628)
    public void setObject(int index, Object newValue, Object secondary, boolean update, CustomType type) throws FieldAccessException {
        Object created = type.newInstance(newValue, secondary);
        this.setObject(index, created, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getWatchedObject(int index) throws FieldAccessException {
        if (GET_KEY_VALUE_METHOD != null) {
            try {
                return GET_KEY_VALUE_METHOD.invoke(this.handle, index);
            }
            catch (Exception e) {
                throw new FieldAccessException("Cannot invoke get key method for index " + index, e);
            }
        }
        try {
            this.getReadWriteLock().readLock().lock();
            Object object = this.getWatchableObjectMap().get(index);
            return object;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    protected ReadWriteLock getReadWriteLock() throws FieldAccessException {
        try {
            if (this.readWriteLock != null) {
                return this.readWriteLock;
            }
            if (READ_WRITE_LOCK_FIELD != null) {
                this.readWriteLock = (ReadWriteLock)FieldUtils.readField(READ_WRITE_LOCK_FIELD, this.handle, true);
                return this.readWriteLock;
            }
            this.readWriteLock = new ReentrantReadWriteLock();
            return this.readWriteLock;
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException("Unable to read lock field.", e);
        }
    }

    protected Map<Integer, Object> getWatchableObjectMap() throws FieldAccessException {
        if (this.watchableObjects == null) {
            this.watchableObjects = (Map)VALUE_MAP_ACCESSOR.get(this.handle);
        }
        return this.watchableObjects;
    }

    public static WrappedDataWatcher getEntityWatcher(Entity entity) throws FieldAccessException {
        if (ENTITY_DATA_FIELD == null) {
            ENTITY_DATA_FIELD = FuzzyReflection.fromClass(MinecraftReflection.getEntityClass(), true).getFieldByType("datawatcher", MinecraftReflection.getDataWatcherClass());
        }
        BukkitUnwrapper unwrapper = new BukkitUnwrapper();
        try {
            Object nsmWatcher = FieldUtils.readField(ENTITY_DATA_FIELD, unwrapper.unwrapItem(entity), true);
            if (nsmWatcher != null) {
                return new WrappedDataWatcher(nsmWatcher);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException("Cannot access DataWatcher field.", e);
        }
    }

    private static void initialize() throws FieldAccessException {
        if (HAS_INITIALIZED) {
            return;
        }
        HAS_INITIALIZED = true;
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(MinecraftReflection.getDataWatcherClass(), true);
        for (Field lookup : fuzzy.getFieldListByType(Map.class)) {
            if (Modifier.isStatic(lookup.getModifiers())) {
                TYPE_MAP_ACCESSOR = Accessors.getFieldAccessor(lookup, true);
                continue;
            }
            VALUE_MAP_ACCESSOR = Accessors.getFieldAccessor(lookup, true);
        }
        WrappedDataWatcher.initializeSpigot(fuzzy);
        CUSTOM_MAP = WrappedDataWatcher.initializeCustom();
        TYPE_MAP = (Map)TYPE_MAP_ACCESSOR.get(null);
        try {
            READ_WRITE_LOCK_FIELD = fuzzy.getFieldByType("readWriteLock", ReadWriteLock.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (MinecraftReflection.isUsingNetty()) {
            ENTITY_FIELD = fuzzy.getFieldByType("entity", MinecraftReflection.getEntityClass());
            ENTITY_FIELD.setAccessible(true);
        }
        WrappedDataWatcher.initializeMethods(fuzzy);
    }

    private static Map<Class<?>, Integer> initializeCustom() {
        HashMap map = Maps.newHashMap();
        for (CustomType type : CustomType.values()) {
            if (type.getSpigotClass() == null) continue;
            map.put(type.getSpigotClass(), type.getTypeId());
        }
        return map;
    }

    private static void initializeSpigot(FuzzyReflection fuzzy) {
        if (TYPE_MAP_ACCESSOR != null && VALUE_MAP_ACCESSOR != null) {
            return;
        }
        for (Field lookup : fuzzy.getFields()) {
            Class<?> type = lookup.getType();
            if (!TroveWrapper.isTroveClass(type)) continue;
            ReadOnlyFieldAccessor accessor = TroveWrapper.wrapMapField(Accessors.getFieldAccessor(lookup, true), new Function<Integer, Integer>(){

                public Integer apply(@Nullable Integer value) {
                    if (value == 0) {
                        return -1;
                    }
                    return value;
                }
            });
            if (Modifier.isStatic(lookup.getModifiers())) {
                TYPE_MAP_ACCESSOR = accessor;
                continue;
            }
            VALUE_MAP_ACCESSOR = accessor;
        }
        if (TYPE_MAP_ACCESSOR == null) {
            throw new IllegalArgumentException("Unable to find static type map.");
        }
        if (VALUE_MAP_ACCESSOR == null) {
            throw new IllegalArgumentException("Unable to find static value map.");
        }
    }

    private static void initializeMethods(FuzzyReflection fuzzy) {
        List<Method> candidates = fuzzy.getMethodListByParameters(Void.TYPE, new Class[]{Integer.TYPE, Object.class});
        try {
            GET_KEY_VALUE_METHOD = fuzzy.getMethodByParameters("getWatchableObject", MinecraftReflection.getWatchableObjectClass(), (Class<?>[])new Class[]{Integer.TYPE});
            GET_KEY_VALUE_METHOD.setAccessible(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (Method method : candidates) {
            if (!method.getName().startsWith("watch")) {
                CREATE_KEY_VALUE_METHOD = method;
                continue;
            }
            UPDATE_KEY_VALUE_METHOD = method;
        }
        if (UPDATE_KEY_VALUE_METHOD == null || CREATE_KEY_VALUE_METHOD == null) {
            if (candidates.size() <= 1) {
                throw new IllegalStateException("Unable to find create and update watchable object. Update ProtocolLib.");
            }
            CREATE_KEY_VALUE_METHOD = candidates.get(0);
            UPDATE_KEY_VALUE_METHOD = candidates.get(1);
            try {
                WrappedDataWatcher watcher = new WrappedDataWatcher();
                watcher.setObject(0, 0);
                watcher.setObject(0, 1);
                if (watcher.getInteger(0) != 1) {
                    throw new IllegalStateException("This cannot be!");
                }
            }
            catch (Exception e) {
                UPDATE_KEY_VALUE_METHOD = candidates.get(0);
                CREATE_KEY_VALUE_METHOD = candidates.get(1);
            }
        }
    }

    @Override
    public Iterator<WrappedWatchableObject> iterator() {
        return Iterators.transform(this.getWatchableObjectMap().values().iterator(), (Function)new Function<Object, WrappedWatchableObject>(){

            public WrappedWatchableObject apply(@Nullable Object item) {
                if (item != null) {
                    return new WrappedWatchableObject(item);
                }
                return null;
            }
        });
    }

    public Map<Integer, WrappedWatchableObject> asMap() {
        if (this.mapView == null) {
            this.mapView = new ConvertedMap<Integer, Object, WrappedWatchableObject>(this.getWatchableObjectMap()){

                @Override
                protected Object toInner(WrappedWatchableObject outer) {
                    if (outer == null) {
                        return null;
                    }
                    return outer.getHandle();
                }

                @Override
                protected WrappedWatchableObject toOuter(Object inner) {
                    if (inner == null) {
                        return null;
                    }
                    return new WrappedWatchableObject(inner);
                }
            };
        }
        return this.mapView;
    }

    public String toString() {
        return this.asMap().toString();
    }

    public Entity getEntity() {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalStateException("This method is only supported on 1.7.2 and above.");
        }
        try {
            return (Entity)MinecraftReflection.getBukkitEntity(ENTITY_FIELD.get(this.handle));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve entity.", e);
        }
    }

    public void setEntity(Entity entity) {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalStateException("This method is only supported on 1.7.2 and above.");
        }
        try {
            ENTITY_FIELD.set(this.handle, BukkitUnwrapper.getInstance().unwrapItem(entity));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set entity.", e);
        }
    }

    @Spigot(minimumBuild=1628)
    public static enum CustomType {
        BYTE_SHORT("org.spigotmc.ProtocolData$ByteShort", 0, Short.TYPE),
        DUAL_BYTE("org.spigotmc.ProtocolData$DualByte", 0, Byte.TYPE, Byte.TYPE),
        HIDDEN_BYTE("org.spigotmc.ProtocolData$HiddenByte", 0, Byte.TYPE),
        INT_BYTE("org.spigotmc.ProtocolData$IntByte", 2, Integer.TYPE, Byte.TYPE),
        DUAL_INT("org.spigotmc.ProtocolData$DualInt", 2, Integer.TYPE, Integer.TYPE);

        private Class<?> spigotClass;
        private ConstructorAccessor constructor;
        private FieldAccessor secondaryValue;
        private int typeId;

        private CustomType(String className, int typeId, Class<?> ... parameters) {
            try {
                this.spigotClass = Class.forName(className);
                this.constructor = Accessors.getConstructorAccessor(this.spigotClass, parameters);
                this.secondaryValue = parameters.length > 1 ? Accessors.getFieldAccessor(this.spigotClass, "value2", true) : null;
            }
            catch (ClassNotFoundException e) {
                System.out.println("[ProtocolLib] Unable to find " + className);
                this.spigotClass = null;
            }
            this.typeId = typeId;
        }

        Object newInstance(Object value) {
            return this.newInstance(value, null);
        }

        Object newInstance(Object value, Object secondary) {
            Preconditions.checkNotNull((Object)value, (Object)"value cannot be NULL.");
            if (this.hasSecondary()) {
                return this.constructor.invoke(value, secondary);
            }
            if (secondary != null) {
                throw new IllegalArgumentException("Cannot construct " + (Object)((Object)this) + " with a secondary value");
            }
            return this.constructor.invoke(value);
        }

        void setSecondary(Object instance, Object secondary) {
            if (!this.hasSecondary()) {
                throw new IllegalArgumentException((Object)((Object)this) + " does not have a secondary value.");
            }
            this.secondaryValue.set(instance, secondary);
        }

        Object getSecondary(Object instance) {
            if (!this.hasSecondary()) {
                throw new IllegalArgumentException((Object)((Object)this) + " does not have a secondary value.");
            }
            return this.secondaryValue.get(instance);
        }

        public boolean hasSecondary() {
            return this.secondaryValue != null;
        }

        public Class<?> getSpigotClass() {
            return this.spigotClass;
        }

        public int getTypeId() {
            return this.typeId;
        }

        @Spigot(minimumBuild=1628)
        public static CustomType fromValue(Object value) {
            for (CustomType type : CustomType.values()) {
                if (!type.getSpigotClass().isInstance(value)) continue;
                return type;
            }
            return null;
        }
    }
}

